<?php

namespace App\Models;

use CodeIgniter\Model;

class EducationModel extends Model
{
    protected $table            = 'education';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'jenjang', 'nama_sekolah', 'jurusan', 'tahun_mulai', 'tahun_selesai',
        'nilai_akhir', 'deskripsi', 'urutan', 'status_pendidikan', 
        'created_at', 'updated_at'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function searchAndFilter($search = '', $filter = [], $sort = 'urutan', $order = 'ASC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_sekolah', $search)
                ->orLike('jurusan', $search)
                ->orLike('deskripsi', $search)
                ->groupEnd();
        }

        if (!empty($filter['jenjang'])) {
            $builder->where('jenjang', $filter['jenjang']);
        }

        if (!empty($filter['tahun_mulai'])) {
            $builder->where('tahun_mulai >=', $filter['tahun_mulai']);
        }

        if (!empty($filter['tahun_selesai'])) {
            $builder->where('tahun_selesai <=', $filter['tahun_selesai']);
        }

        if (!empty($filter['status_pendidikan'])) {
            $builder->where('status_pendidikan', $filter['status_pendidikan']);
        }

        $allowedSorts = ['urutan', 'jenjang', 'nama_sekolah', 'tahun_mulai', 'tahun_selesai', 'nilai_akhir', 'status_pendidikan'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'urutan';
        $order = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}

